module mousespotting

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program monitors mouse input that is sent to a Window which consists 
//  of a CompoundControl which consists of CustomControl.
//  ********************************************************************************

import StdEnv,StdIO,stringconv

::  NoState
    =   NoState

Start :: *World -> *World
Start world
    #	(windowid, world)= openId world
    #	(controlid,world)= openId world
	=	startIO NoState NoState [initialise windowid controlid] [] world
where
	initialise windowid controlid ps
		# custom	= CustomControl customsize (look "")
						[	ControlMouse	(const True) Able
											(noLS1 (spotting "Control"))
						,	ControlId		controlid
						]
		# compound	= CompoundControl custom
						[	ControlMouse	(const True) Able
											(noLS1 (spotting "Compound"))
						,   ControlSize     {w=customsize.w+2*margin
											,h=customsize.h+2*margin
											}
						,	ControlLook		(look "")
						]
		# window	= Window "mousespotting" compound
						[	WindowMouse		(const True) Able
											(noLS1 (spotting "Window"))
						,   WindowId		windowid
						,	WindowSize		{w=customsize.w+4*margin
											,h=customsize.h+4*margin
											}
						,	WindowHMargin	margin margin
						,   WindowVMargin	margin margin
						,	WindowClose		(noLS closeProcess)
						]
		# (error,ps)	= openWindow NoState window ps
        | error<>NoError
            =	abort "mousespotting could not open window"
        | otherwise
            =	ps
	where
		customsize	= {w=550,h=100}
        margin		= 10
        spotting who mouse ps
            =	appPIO (setWindow windowid
                       [setControlLooks [(controlid,True,look text)]]) ps
        where
        	text	= who+++":"+++toString mouse
        look text _ {newFrame}
            =	[ setPenColour	White, fill	newFrame
                , setPenColour	Black, draw newFrame
                , drawAt {x=10,y=customsize.h/2} text
                ]
